package w83b.w83bUtilidadesComunes;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;

/**
 * 
 * @author 
 *
 */
public abstract class W83bUtilidades{
	
	/**
	 * Funcin que elimina acentos y caracteres especiales de
	 * una cadena de texto.
	 * @param input
	 * @return cadena de texto limpia de acentos y caracteres especiales.
	 */
	public static String quitarCaracteresEspeciales(String input) {
	    // Cadena de caracteres original a sustituir.
	    String original = "u";
	    // Cadena de caracteres ASCII que reemplazarn los originales.
	    String ascii = "aaaeeeiiiooouuunAAAEEEIIIOOOUUUNcC";
	    //Cadena de caracteres que directamente desaparecern
	    String desaparecen="\\!\"$%&/()=?|@#~`+-.,^*Ǩ_:;[]}{<> ";
	    String output = input;
	    for (int i=0; i<original.length(); i++) {
	        // Reemplazamos los caracteres especiales.
	        output = output.replace(original.charAt(i), ascii.charAt(i));
	    }
	    for (int i=0; i<desaparecen.length(); i++) {
	    	// Reemplazamos los caracteres especiales.
	    	output = output.replace(desaparecen.charAt(i), '\0');	    	
	    }
	    
	    return output;
	}//remove1
	/**
	 * Funcin que elimina acentos y caracteres especiales de
	 * una cadena de texto.
	 * @param input
	 * @return cadena de texto limpia de acentos y caracteres especiales.
	 */
	public static String quitarCaracteresEspecialesEspacios(String input) {
		// Cadena de caracteres original a sustituir.
		String original = "u";
		// Cadena de caracteres ASCII que reemplazarn los originales.
		String ascii = "aaaeeeiiiooouuunAAAEEEIIIOOOUUUcC";
		//Cadena de caracteres que directamente desaparecern
		String desaparecen="!\"$%&/=|@#~`-^Ǩ_:;<> ";
		String output = input;
		for (int i=0; i<original.length(); i++) {
			// Reemplazamos los caracteres especiales.
			output = output.replace(original.charAt(i), ascii.charAt(i));
		}
		output = output.replaceAll("\\\\", "");
		output = output.replaceAll("\\)", "");
		output = output.replaceAll("\\(", "");
		output = output.replaceAll("\\?", "");
		output = output.replaceAll("\\", "");
		output = output.replaceAll("\\+", "");
		output = output.replaceAll("\\*", "");
		output = output.replaceAll("\\[", "");
		output = output.replaceAll("\\]", "");
		output = output.replaceAll("\\{", "");
		output = output.replaceAll("\\}", "");
		output = output.replaceAll("\\,", "");
		output = output.replaceAll("\\.", "");
		for (int i=0; i<desaparecen.length(); i++) {
			// Reemplazamos los caracteres especiales.
//			System.out.println(String.valueOf(desaparecen.charAt(i)));
			output = output.replaceAll(String.valueOf(desaparecen.charAt(i)), "");	    	
//			System.out.println(String.valueOf(output));
		}
		
		return output;
	}//remove1
	
	public static List addUnique(List lista, String elemento){

		if(!lista.contains(elemento)){
			lista.add(elemento);
		}

		return lista;
	}
	
	public static String rellenarCaracter(String text,String x, int longitud,boolean izquierda){//NOPMD	
		if (text==null){
			text="";
		}
		for (int i=text.length();i<longitud;i=i+x.length())
		{
			if(izquierda)
			{
				text=x+text;
			}else{
				text+=x;
			}
			
		}
		return text;
	}
	public static String convertirAVasioSiNulo(String elemento)
	{
		if(null==elemento)
		{
			return W83bClsConstantes.VACIO;
		}else{
			return elemento;
		}
	}
	public static String convertirAVasioSiNuloArray(String[] elemento, int i)
	{
		if(elemento.length>0)
		{
			return convertirAVasioSiNulo(elemento[i]);
		}else{
			return W83bClsConstantes.VACIO;
		}
	}
	public static String transformarPorcentaje(double dato)
	{
		
		String datoS=String.valueOf(W83bUtilidades.redondearDouble(dato,2));
		String datoPorcentaje=datoS;
		int longitud=datoS.length();
		int i=datoS.indexOf(".");
		
		 if(datoS.indexOf(".0")+2==longitud)
		   {
			   datoPorcentaje=datoS.substring(0,i).concat("%");
		   }else{
			  
			   if(i+3>longitud)
			   {
				   datoPorcentaje=datoS.substring(0,i+2).concat("%");
			   }else{
				   datoPorcentaje=datoS.substring(0,i+3).concat("%");
			   }
			  
		   }
		 return datoPorcentaje;
	}
	public static double redondearDouble(double numero, int decimales)
		{
				int i=1;
				for(int j=0;j<decimales;j++)
				{
					i=i*10;
				}
		       return Math.rint(numero*i)/i;
		}
	
	/**
	 * Numero.
	 * 
	 * @param num the num
	 * @return the int
	 */
	public static int numero(String num){		
		Integer n = new Integer(num.trim());
		return n.intValue();
	}
	
	
	/**
	 * Porcentaje.
	 * 
	 * @param totalParcial the total parcial
	 * @param total the total
	 * @return the float
	 */
	public static float porcentaje(int totalParcial,int total){
		
		if (total==0){
			return 0;
		}
		else{
			return((float)totalParcial)/(float)total;			
		}
	}
	public static String inicialesMayusculas(String s)
	{
		String trans=s.toLowerCase();
		String [] split=trans.split(" ");
		String resul="";
		String palabra;
		String resto;
		String inicial;
		for(int i=0;i<split.length;i++)
		{
			if(i!=0)
			{
				resul=resul.concat(" ");
			}
			inicial="";
			resto="";
			palabra=split[i];
			if(palabra.length()>0)
			{
				inicial=palabra.substring(0,1).toUpperCase();
				if(palabra.length()>1)
				{
					resto=palabra.substring(1, palabra.length());
				}
			}
			
			
			resul=resul.concat(inicial.concat(resto));
		}
		return resul;
	}
	public static String calcularporcentajePdf(int totalparc,int total){
		DecimalFormatSymbols simbolos = new DecimalFormatSymbols();
		simbolos.setDecimalSeparator(',');
		DecimalFormat formateador = new DecimalFormat("####.##%",simbolos);
		if (total==0){
			return "0%";
		}
		else{
			float n=((float)totalparc)/(float)total;
			return formateador.format(n);
		}
	}
	public static String separadorMiles(int n){
		DecimalFormatSymbols simbolos = new DecimalFormatSymbols();
		simbolos.setGroupingSeparator('.');
    	DecimalFormat formateador = new DecimalFormat("#,##0",simbolos);
	    return formateador.format(n);
		
	}
	
	 //Devuelve true si en una cadena que llega todos son espacios, false en caso contrario
	 public static boolean sonEspacios(String cad)
	 {
	 for(int i =0; i<cad.length(); i++)
		 if(cad.charAt(i) != ' ')
		 return false;
		 
		 return true;
	 }
	 
	 public static String formatoFechaFicheroVuelta(String fecha){
		String fechafinal="";
		if (fecha!=null&&!"".equals(fecha)){
			String[] fechaformateada=fecha.split("/");
			fechafinal=fechaformateada[2]+fechaformateada[1]+fechaformateada[0];
		}
		return fechafinal;
	}
}